using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using Microsoft.Reporting.WinForms;
using System.Reflection;
using System.IO;
namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgReportBloodAvailability
	/// </summary>
	public class DlgReportBloodAvailability : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private BOL.BloodAvailability _report;

		private System.Windows.Forms.Panel pnlReport;
		private System.Windows.Forms.Button btnPrint;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.Button btnCancel;
		
		/// <summary>
		/// BloodAvailabilityReport object
		/// </summary>
        public LocalReport bloodAvailabilityReport = new LocalReport();
		
		private System.Windows.Forms.PrintDialog printDialog1;
        private gov.va.med.vbecs.GUI.controls.VbecsReportViewer rvBloodAvailabilityReport;

		private System.ComponentModel.IContainer components = null;

		/// <summary>
		/// Constructor
		/// </summary>
		public DlgReportBloodAvailability()
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();
			//
			SetComponentProperties();
		}

		/// <summary>
		/// Constructor
		/// </summary>
		public DlgReportBloodAvailability(BOL.BloodAvailability bloodAvailability):this()
		{
			this.Report = bloodAvailability;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(DlgReportBloodAvailability));
            this.pnlReport = new System.Windows.Forms.Panel();
            this.rvBloodAvailabilityReport = new gov.va.med.vbecs.GUI.controls.VbecsReportViewer();
            this.grpImage = new System.Windows.Forms.GroupBox();
            this.pictureBox1 = new System.Windows.Forms.PictureBox();
            this.btnPrint = new System.Windows.Forms.Button();
            this.btnCancel = new System.Windows.Forms.Button();
            this.printDialog1 = new System.Windows.Forms.PrintDialog();
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            this.pnlReport.SuspendLayout();
            this.grpImage.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).BeginInit();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.Size = new System.Drawing.Size(742, 30);
            this.vbecsLogo1.TabIndex = 3;
            this.vbecsLogo1.Title = "Blood Availability";
            // 
            // lblRequiredField
            // 
            this.lblRequiredField.Location = new System.Drawing.Point(0, 509);
            this.lblRequiredField.TabIndex = 4;
            // 
            // pnlReport
            // 
            this.pnlReport.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.pnlReport.Controls.Add(this.rvBloodAvailabilityReport);
            this.pnlReport.Controls.Add(this.grpImage);
            this.pnlReport.Location = new System.Drawing.Point(1, 32);
            this.pnlReport.Name = "pnlReport";
            this.pnlReport.Size = new System.Drawing.Size(740, 464);
            this.pnlReport.TabIndex = 0;
            // 
            // rvBloodAvailabilityReport
            // 
            this.rvBloodAvailabilityReport.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.rvBloodAvailabilityReport.Location = new System.Drawing.Point(60, 4);
            this.rvBloodAvailabilityReport.Name = "rvBloodAvailabilityReport";
            this.rvBloodAvailabilityReport.Size = new System.Drawing.Size(677, 457);
            this.rvBloodAvailabilityReport.TabIndex = 2;
            this.rvBloodAvailabilityReport.RenderingComplete += new Microsoft.Reporting.WinForms.RenderingCompleteEventHandler(this.rvBloodAvailabilityReport_RenderingComplete);
            this.rvBloodAvailabilityReport.RenderingBegin += new System.ComponentModel.CancelEventHandler(this.rvBloodAvailabilityReport_RenderingBegin);
            // 
            // grpImage
            // 
            this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpImage.BackColor = System.Drawing.SystemColors.Control;
            this.grpImage.Controls.Add(this.pictureBox1);
            this.grpImage.Location = new System.Drawing.Point(4, 0);
            this.grpImage.Name = "grpImage";
            this.grpImage.Size = new System.Drawing.Size(52, 462);
            this.grpImage.TabIndex = 1;
            this.grpImage.TabStop = false;
            // 
            // pictureBox1
            // 
            this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
            this.pictureBox1.Location = new System.Drawing.Point(4, 16);
            this.pictureBox1.Name = "pictureBox1";
            this.pictureBox1.Size = new System.Drawing.Size(45, 45);
            this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
            this.pictureBox1.TabIndex = 38;
            this.pictureBox1.TabStop = false;
            // 
            // btnPrint
            // 
            this.btnPrint.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnPrint.DialogResult = System.Windows.Forms.DialogResult.OK;
            this.btnPrint.Image = ((System.Drawing.Image)(resources.GetObject("btnPrint.Image")));
            this.btnPrint.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.btnPrint.Location = new System.Drawing.Point(584, 500);
            this.btnPrint.Name = "btnPrint";
            this.btnPrint.Size = new System.Drawing.Size(75, 23);
            this.btnPrint.TabIndex = 1;
            this.btnPrint.Text = "&Print";
            this.btnPrint.Click += new System.EventHandler(this.btnPrint_Click);
            // 
            // btnCancel
            // 
            this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnCancel.Location = new System.Drawing.Point(664, 500);
            this.btnCancel.Name = "btnCancel";
            this.btnCancel.Size = new System.Drawing.Size(75, 23);
            this.btnCancel.TabIndex = 2;
            this.btnCancel.Text = "&Close";
            this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
            // 
            // printDialog1
            // 
            this.printDialog1.AllowPrintToFile = false;
            // 
            // DlgReportBloodAvailability
            // 
            this.AcceptButton = this.btnPrint;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.btnCancel;
            this.ClientSize = new System.Drawing.Size(742, 523);
            this.Controls.Add(this.btnCancel);
            this.Controls.Add(this.btnPrint);
            this.Controls.Add(this.pnlReport);
            this.hlphelpChm.SetHelpKeyword(this, "Blood_Availability.htm");
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.Name = "DlgReportBloodAvailability";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.Text = "VBECS - Blood Availability";
            this.Load += new System.EventHandler(this.DlgReportBloodAvailability_Load);
            this.Controls.SetChildIndex(this.pnlReport, 0);
            this.Controls.SetChildIndex(this.btnPrint, 0);
            this.Controls.SetChildIndex(this.btnCancel, 0);
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            this.pnlReport.ResumeLayout(false);
            this.grpImage.ResumeLayout(false);
            this.grpImage.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).EndInit();
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion

		/// <summary>
		/// Report
		/// </summary>
		public BOL.BloodAvailability Report
		{
			get
			{
				if (this._report == null)
				{
					throw new ArgumentNullException("Report");
				}
				return this._report;
			}
			set
			{
				this._report = value;
				//
				if (value != null)
				{
					if (this._report.IsIndividualPatientReport)
					{
						this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC049.DlgReportBloodAvailability_Patient());
					}
					else
					{
						this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC049.DlgReportBloodAvailability_Print());
					}
					//
					using (new WaitCursor())
					{
						this.CreateReport();
					}
				}
			}
		}

		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			//
			this.SetThisToolTip(this.btnCancel,Common.StrRes.Tooltips.Common.Cancel());
			this.SetThisToolTip(this.btnPrint,Common.StrRes.Tooltips.Common.Print());
            BOL.VbecsReport.SetUpReportButtons(this.rvBloodAvailabilityReport);
        }

		private void CreateReport()
		{
            DataSet dsReport = _report.GetBloodAvailabilityReport();
            DataSet dsHeader = BOL.VbecsReport.GetReportHeader(ThisUser.UserName);
            DataSet dsFooter = BOL.VbecsReport.GetReportFooter(_report.ReportCriteria);

            ReportDataSource reportSource = new ReportDataSource();
            if (dsReport.Tables.Count > 0)
            {
                reportSource.Name = "BloodAvailabilityDataSet";
                reportSource.Value = dsReport.Tables[0];
            }

            ReportDataSource reportSourceHeader = new ReportDataSource();
            if (dsHeader.Tables.Count > 0)
            {
                reportSourceHeader.Name = "ReportHeaderDataSet";
                reportSourceHeader.Value = dsHeader.Tables[0];
            }

            ReportDataSource reportSourceFooter = new ReportDataSource();
            if (dsFooter.Tables.Count > 0)
            {
                reportSourceFooter.Name = "ReportFooterDataSet";
                reportSourceFooter.Value = dsFooter.Tables[0];
            }
            
            Assembly assembly = Assembly.LoadFrom("Reports.dll");
            Stream stream = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.BloodAvailability.BloodAvailabilityReport.rdlc");

            this.rvBloodAvailabilityReport.LocalReport.DataSources.Add(reportSource);
            this.rvBloodAvailabilityReport.LocalReport.DataSources.Add(reportSourceHeader);
            this.rvBloodAvailabilityReport.LocalReport.DataSources.Add(reportSourceFooter);
            this.rvBloodAvailabilityReport.LocalReport.LoadReportDefinition(stream);
            this.rvBloodAvailabilityReport.LocalReport.SetParameters(new ReportParameter("ReportTitle", _report.GenerateReportTitle()));

            this.rvBloodAvailabilityReport.RefreshReport();
        }

		// Prints the currently displayed report.
		private void btnPrint_Click(object sender, System.EventArgs e)
		{
            //CR 3449
            try
            {
                this.rvBloodAvailabilityReport.PrintDialog();
            }
            catch (System.InvalidOperationException)
            {
            }
        }

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

        private void DlgReportBloodAvailability_Load(object sender, EventArgs e)
        {

            this.rvBloodAvailabilityReport.RefreshReport();
        }

        /// <summary>
        /// CR 3581
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void rvBloodAvailabilityReport_RenderingBegin(object sender, CancelEventArgs e)
        {
            this.btnPrint.Enabled = false;
        }

        /// <summary>
        /// CR 3581
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void rvBloodAvailabilityReport_RenderingComplete(object sender, RenderingCompleteEventArgs e)
        {
            this.btnPrint.Enabled = true;
        }
	}
}
